<?php
$file = 'remote_data.txt';

if (!file_exists($file)) {
    echo "No data found.";
    exit;
}

$rows = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Remote Data</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f8f9fa;
        }
        h2 {
            color: #343a40;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        button {
            padding: 10px 20px;
            background-color: #dc3545;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-bottom: 20px;
        }
        button:hover {
            background-color: #c82333;
        }
    </style>
    <script>
        // Function to clear all data with a confirmation prompt
        function clearAllData() {
            if (confirm("Are you sure you want to clear all data?")) {
                fetch('clear_data.php', {
                    method: 'POST'
                })
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    location.reload(); // Refresh the page to reinitialize polling
                })
                .catch(error => console.error('Error:', error));
            }
        }

        // Polling function to check for eligible rows every 10 seconds
        function startPolling() {
            setInterval(function() {
                fetch('send_to_google.php')
                    .then(response => response.text())
                    .then(data => console.log(data))
                    .catch(error => console.error('Error:', error));
            }, 10000); // 10000 milliseconds = 10 seconds
        }

        // Start polling when the page loads
        window.onload = startPolling;
    </script>
</head>
<body>
    <h2>Carts Abadonments</h2>
    <button onclick="clearAllData()">Clear All</button>

    <table>
        <tr>
            <th>User ID</th>
            <th>Timestamp</th>
            <th>Name</th>
            <th>Phone</th>
            <th>WhatsApp</th>
            <th>Email</th>
            <th>Address</th>
            <th>State</th>
            <th>Gender</th>
            <th>Package</th>
            <th>Source</th>
        </tr>
        <?php if (!empty($rows)): ?>
            <?php foreach ($rows as $row): ?>
                <?php $data = explode("\t", $row); ?>
                <tr>
                    <?php foreach ($data as $key => $value): ?>
                        <?php if ($key <= 10): ?>
                            <td><?php echo htmlspecialchars($value); ?></td>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="11">No data available.</td></tr>
        <?php endif; ?>
    </table>
</body>
</html>
